extends RigidBody
var type = 2
var starting_direction = Vector3(0,1,-2).normalized()
var direction = starting_direction
var local_direction = starting_direction
var starting_pitch_axis = Vector3(1,0,0)
var pitch_axis = starting_pitch_axis
var force_magnitude = 20
var camera_rotation = 0
var starting_position = Vector3(0, 2, 10)

var expended = false

var aiming = true

signal aim_updated(amount)
signal reset()

func _ready():
	reset()
	emit_signal('aim_updated', force_magnitude)

func re_aim(cam_rads):
	var start = starting_position
	var y = Vector3(0,1,0)
	var new_start_position = start.rotated(y, cam_rads)
	pitch_axis = starting_pitch_axis.rotated(y, cam_rads)
	
	direction = local_direction.rotated(Vector3(0,1,0), camera_rotation)
	set_translation(new_start_position)
	camera_rotation = cam_rads
	emit_signal("aim_updated", force_magnitude)

func reset():
	aiming = true
	expended = false
	set_mode(RigidBody.MODE_STATIC)
	emit_signal('aim_updated', force_magnitude)

func handle_action(action, delta):
	if not aiming: 
		return
	var changed = false
	
	if action == 'aim_up':
		local_direction = local_direction.rotated(Vector3(1,0,0), .3 * delta)
		changed = true
	if action == 'aim_down':
		local_direction = local_direction.rotated(Vector3(1,0,0), -.3 * delta)
		changed = true
	if action == 'aim_right':
		local_direction = local_direction.rotated(Vector3(0,1,0), -.3 * delta)
		changed = true
	if action == 'aim_left':
		local_direction = local_direction.rotated(Vector3(0,1,0), .3 * delta)
		changed = true
	if action == 'aim_harder':
		force_magnitude += 10 * delta
		changed = true
	if action == 'aim_softer':
		force_magnitude -= 10 * delta
		changed = true
		
	if changed:
		direction = local_direction.rotated(Vector3(0,1,0), camera_rotation)
		force_magnitude = clamp(force_magnitude, 10, 30)
		emit_signal('aim_updated', force_magnitude)

func fire():
	if not aiming: 
		return
	set_mode(RigidBody.MODE_RIGID)
	set_linear_velocity(direction*force_magnitude)
	aiming = false
	
	emit_signal('reset')
