extends CanvasLayer

var high_score = 0

var game_start = true
var valid_action_index = 0
var valid_actions = [
	[['aim_up', 'aim_down'],[]],
	[['aim_left', 'aim_right'],[]],
	[['aim_harder', 'aim_softer'],[]],
	[['rotate_right', 'rotate_left'],[]],
	[[],['fire']],
	[[],['reset']],
	[[],[]]
]

var continue_text = '[press space to continue]'

var tutorial_text = [
	'Press [w] to aim up and [s] to aim down!',
	'Press [a] to aim left and [d] to aim right!',
	'Press [Shift] to increase power and [Ctrl] to decrease power!',
	'Press [Left Arrow] and [Right Arrow] (Or [Right Mouse Button + Drag]) to aim the camera left and right!',
	'Press [Space] to fire the ball!',
	'Press [R] to reset!',
	'Try to knock blocks out without toppling the tower!'
]


signal tutorial_finished()
signal send_tutorial_signal(action, delta)

func _ready():
	$TutorialGrid/TutorialText.text = tutorial_text[valid_action_index]
	$TutorialGrid/ContinueText.text = continue_text

func _on_birb_aim_updated(amount):
	$Power/PowerBar.value = amount
	$Power/PowerText.text = str(int(amount))

func _on_Bricks_update_score(score):
	$TumbleIndicator/Count.text = str(score)
	if score > high_score:
		high_score = score
		$TumbleIndicator/HighScoreCount.text = str(score)

func _on_Bricks_game_over():
	$RestartScreen.visible = true


func _on_scene3d_reset():
	$RestartScreen.visible = false

func _input(event):
	if not game_start:
		return 
		
	for action in valid_actions[valid_action_index][1]:
		
		if event.is_action_pressed(action):
			print(action)
			emit_signal("send_tutorial_signal", action, 0)
	
	if event.is_action_pressed("fire"):
		continue_tutorial()
			
func continue_tutorial():
	valid_action_index += 1
	
	if valid_action_index >= len(valid_actions):
		$TutorialGrid.visible = false
		emit_signal("tutorial_finished")
		game_start = false
		return
	$TutorialGrid/TutorialText.text = tutorial_text[valid_action_index]
	$TutorialGrid/ContinueText.text = continue_text
	
	print(tutorial_text[valid_action_index])
	print(valid_actions[valid_action_index])
		
			
func _process(delta):
	if not game_start:
		return 
	for action in valid_actions[valid_action_index][0]:
		if Input.is_action_pressed(action):
			print(action)
			emit_signal("send_tutorial_signal", action, delta)
			
		
