extends Spatial

var brick = preload("res://brick.tscn")

var rng = RandomNumberGenerator.new()

signal game_over()
signal update_score(score)

var lost = false

var level = 0
var bricks_removed = 0
var bricks_total = 0

# Called when the node enters the scene tree for the first time.
func _ready():
	rng.randomize()
	respawn()


func respawn():
	lost = false
	for n in get_children():
		remove_child(n)
		n.queue_free()
	
	for i in range(10):
		level = i+1
		place_level(level)


func place_level(level):
	var x = level % 2
	var y = 1 - x

	for i in [-.51, 0, .51]:
		var new_brick = brick.instance()
		var height_offset = rng.randf_range(0, .04)
		new_brick.set_scale(Vector3(1, 1 + height_offset, 1))
		new_brick.set_rotation_degrees(Vector3(0, y*90, 0))
		new_brick.set_translation(Vector3(x * i, .3*level, y * i))
		new_brick.init(level)
		new_brick.connect('on_ground', self, '_brick_on_ground')
		new_brick.connect('game_over', self, '_game_over')
		add_child(new_brick)

func _brick_on_ground(brick, was_hit_by_birb):
	if lost:
		return
	print('brick on ground signal')
	#remove_child(brick)
	#brick.queue_free()
	bricks_removed += 1
	bricks_total += 1
	emit_signal("update_score", bricks_total)
	while bricks_removed >= 3:
		var new_level = level+1
		level = new_level
		place_level(new_level)
		bricks_removed -= 3

func _on_birb_reset():
	for n in get_children():
		n.reset()
		
func _game_over():
	if not lost: 
		emit_signal("game_over")
		for brick in get_children():
			brick.explode()
		lost = true
		bricks_removed = 0
		bricks_total = 0
		emit_signal("update_score", bricks_removed)
	#bricks_removed = 0
	#respawn()
